# -*- coding: utf-8 -*- 
# http://scipy-lectures.github.com


#---------------------------------------------------
#Import důležitých součástí
#---------------------------------------------------
import numpy as np
import scipy as sp
import pylab as plt
from scipy import signal
import matplotlib as mat
import random as rand       # modul pro generování náhodného čísla ze zvoleného intervalu

#---------------------------------------------------
#Funkce na prahovani
#---------------------------------------------------
def Prahovani(A,UrovenPrahovani=0.1):
    k = 0.5       # konstanta - určuje viditelnost okraje bunky (k=0 => nejlépe viditelné; k=1 => neviditelné,plynulý přechod)
    A[A<UrovenPrahovani] = k*UrovenPrahovani    # všechna čísla menší než UrovenPrahovani se nahradí hodnotou k*UrovenPrahovani  
    A = A - k*UrovenPrahovani                   # nejnižší hodnota bude 0
    return A

#---------------------------------------------------
#Definování konstant
#---------------------------------------------------
e = 2.718281828459045
Pi = 3.14159265358979

#---------------------------------------------------
#Funkce pro vykreslení bunky
#--------------------------------------------------- 
# U funkce pro vykreslení bunky lze nastavit velikost zorného pole, polohu, šířku a výšku bunky i její natočení  
def VykresleniBunky(x,y, SouradniceX=-1.5, SouradniceY=1.0, Sirka=1.0, Vyska=0.8, Natoceni=40.0):
    Natoceni = Natoceni*Pi/float(180)                   # Python počítá implicitně s radiány, tento převod umožnuje zadávat stupně
    x1 = x - SouradniceX                                # Posun bunky do počátku po ose "x"
    y1 = y - SouradniceY                                # Posun bunky do počátku po ose "y"
    x2 = x1*np.cos(Natoceni) + y1*np.sin(Natoceni)      # natočení osy "x"
    y2 = -x1*np.sin(Natoceni) + y1*np.cos(Natoceni)     # natočení osy "y"
    x3 = x2 / Sirka                                     # (zpětné) natažení bunky v ose "x"
    y3 = y2 / Vyska                                     # (zpětné) natažení bunky v ose "y"
    bunka = e**(-1*(x3**2+y3**2))                       # funkce bunky - připomíná funkci normálního rozdělení
    bunka = Prahovani(bunka)                            # zprahování bunky - zviditelnění její hranice
    HmotnostBunky = np.sum(bunka)                       # normování bunky -
    bunka = 1000*bunka/HmotnostBunky                    # - aby měla stálou "hmotnost"
    return bunka

#---------------------------------------------------
#Definiční obor + vytvoření bunky
#---------------------------------------------------     

x = np.linspace(-6,6,342)   # obrázek bude mít na šířku 342 px, zorné pole bude od -6 do +6
y = np.linspace(-6,6,258)   # obrázek bude mít na výšku 258 px, zorné pole bude od -6 do +6
P,Q = np.meshgrid(x,y)      # vytvoření dvou dvourozměrných polí (P a Q) o stejných rozměrech


#---------------------------------------------------------------------------
#Funkce pro vyvolání bunky v čase
#---------------------------------------------------------------------------
NasCas = 0.0
SirkaBunky = 0.8
VyskaBunky = 1.1

def BunkaVCase(Cas):
   global SirkaBunky
   global VyskaBunky                     
   ZmenaSirky = rand.randint(-10,10)/440.0  # vygenerování čísla od -10 do 10 a jeho podělení 110 - tak dostaneme náhodné číslo,
   SirkaBunky = SirkaBunky + ZmenaSirky     # které přičteme k šířce naší bunky - ta se bude během pohybu náhodně mírně deformovat
   ZmenaVysky = rand.randint(-10,10)/440.0  # také výška bunky se bude během jejího pohybu náhodně měnit
   VyskaBunky = VyskaBunky + ZmenaVysky     # 
   SouradniceX = 4*np.cos(Cas*Pi/180*3)     # bunka "oběhne" po elipse, skončí na svém původním místě - výpočet její souřadnice "x"
   SouradniceY = 2*np.sin(Cas*Pi/180*3)     # výpočet její souřadnice "y"
   Natoceni = Cas*3                         # výpočet odpovídajícího natočení bunky během jejího oběhu
   BunkaVCase = VykresleniBunky(P,Q, SouradniceX, SouradniceY, SirkaBunky, VyskaBunky, Natoceni)    # vytvoření bunky
   return BunkaVCase                                                       
